using System;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Diagnostics;

namespace DemoApplication
{
	/// <summary>
	/// A read-only RichTextBox
	/// </summary>
	public class ReadOnlyRichTextBox : RichTextBox
	{
		#region ... Protected overrides ...

		/// <summary>
		/// Hook: Called when the control is selected.
		/// </summary>
		/// <param name="e">A <see cref="T:System.EventArgs"></see> that contains the event data.</param>
		protected override void OnEnter( EventArgs e )
		{
			if (!this.FindForm().SelectNextControl( this, true, true, true, false ))
				this.FindForm().Focus();
		}

		#endregion

		/// <summary>
		/// (disabled)
		/// </summary>
		/// <value>Always <see langword="true" />.</value>
		[DefaultValue( true )]
		[Browsable( false )]
		public new bool ReadOnly
		{
			get { return true; }
			set { ; }
		}

		/// <summary>
		/// (disabled)
		/// </summary>
		/// <value>Always <see langword="false" />.</value>
		[DefaultValue( false )]
		[Browsable( false )]
		public new bool TabStop
		{
			get { return false; }
			set { ; }
		}

		#region ... Constructor ...

		/// <summary>
		/// Creates a new <see cref="ReadOnlyRichTextBox"/> instance.
		/// </summary>
		public ReadOnlyRichTextBox()
		{
			base.ReadOnly = true;
			base.TabStop = false;
			this.Cursor = Cursors.Default;
			this.SetStyle( ControlStyles.Selectable, false );
		}

		#endregion
	}
}
