using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace SOAApplication.Services
{
	delegate void SelectionChangedEvent(XmlElement newSelection);

	interface ISelectionService
	{
		event SelectionChangedEvent OnSelectionChanged;
		XmlElement CurrentSelection { get;}
		void Select(XmlElement newSelection);
	}

	class SelectionService : ISelectionService, IService
	{

		#region private state

		private XmlElement m_currentSelection = null;

		#endregion


		#region ISelectionService Members

		public event SelectionChangedEvent OnSelectionChanged;

		public XmlElement CurrentSelection
		{
			get { return m_currentSelection; }
		}

		public void Select(XmlElement newSelection)
		{
			if (newSelection != m_currentSelection)
			{
				m_currentSelection = newSelection;

				if (OnSelectionChanged != null) OnSelectionChanged(m_currentSelection);
			}
		}

		#endregion


		#region IService Members

		public void OnServiceAvailable(Type serviceType)
		{
			if (serviceType.Equals(typeof(IModelService)))
			{
				ServiceBroker.GetService<IModelService>().OnModelChanged 
					+= new ModelChangedEvent(modelSerivce_OnModelChanged);
			}
		}

		#endregion

		#region service dependencies

		void modelSerivce_OnModelChanged()
		{
			Select(null);
		}

		#endregion
	}
}
