using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace SOAApplication.Services
{
	delegate void ModelChangedEvent();

	interface IModelService
	{
		XmlDocument CurrentModel { get;}
		string CurrentFilename { get;}

		event ModelChangedEvent OnModelChanged;

		void LoadModel(string filename);
		void CloseModel();
	}

	class ModelSerivce : IModelService, IService
	{

		#region private state

		private XmlDocument m_currentModel = null;
		private string m_currentFilename = null;

		#endregion

		#region IModelService members

		public event ModelChangedEvent OnModelChanged;

		public XmlDocument CurrentModel
		{
			get { return m_currentModel; }
		}

		public string CurrentFilename
		{
			get { return m_currentFilename; }
		}

		public void CloseModel()
		{
			m_currentFilename = null;
			m_currentModel = null;
		}

		public void LoadModel(string filename)
		{
			if (filename != null)
			{
				m_currentFilename = filename;
				m_currentModel = new XmlDocument();
				m_currentModel.Load(filename);
			}
			else
			{
				CloseModel();
			}
			if (OnModelChanged != null) OnModelChanged();
		}

		#endregion

		#region IService members

		public void OnServiceAvailable(Type serviceType)
		{
			//nothing to do
		}

		#endregion
	}
}
