using System;
using System.Collections.Generic;
using System.Text;

using System.Xml;

namespace SOAApplication.Services
{
	delegate void HistoryEntryAdded(XmlElement newEntry);
	delegate void HistoryCleared();

	interface IHistoryService
	{
		event HistoryCleared OnHistoryCleared;
		event HistoryEntryAdded OnHistoryEntryAdded;

		XmlElement[] CompleteHistory {get;}
		void Reset();
	}

	class HistoryService : IHistoryService, IService
	{

		#region dependencies from other services

		void selectionService_OnSelectionChanged(XmlElement newSelection)
		{
			if (newSelection != null)
			{
				AddToHistory(newSelection);
			}
		}

		void modelService_OnModelChanged()
		{
			Reset();
		}

		#endregion

		#region service implementation

		private List<XmlElement> m_history = new List<XmlElement>();

		private void AddToHistory(XmlElement newSelection)
		{
			m_history.Add(newSelection);

			if (OnHistoryEntryAdded != null) OnHistoryEntryAdded(newSelection);
		}

		private void ClearHistory()
		{
			m_history.Clear();
			if (OnHistoryCleared != null) OnHistoryCleared();
		}

		#endregion

		#region IHistoryService Members

		public event HistoryCleared OnHistoryCleared;

		public event HistoryEntryAdded  OnHistoryEntryAdded;

		public void Reset()
		{
			ClearHistory();
		}

		public XmlElement[]  CompleteHistory
		{
			get { return m_history.ToArray() ; }
		}

		#endregion

		#region IService Members

		/// <summary>
		/// Connects to the services we need
		/// </summary>
		public void OnServiceAvailable(Type serviceType)
		{
			if (serviceType.Equals(typeof(IModelService)))
			{
				ServiceBroker.GetService<IModelService>().OnModelChanged += new ModelChangedEvent(modelService_OnModelChanged);
				return;
			}

			if (serviceType.Equals(typeof(ISelectionService)))
			{
				ServiceBroker.GetService<ISelectionService>().OnSelectionChanged += new SelectionChangedEvent(selectionService_OnSelectionChanged);
			}
		}

		#endregion
	}
}
