using System;
using System.Collections.Generic;
using System.Text;

namespace SOAApplication
{
	static class ServiceBroker
	{
		#region private data

		private static Dictionary<Type, IService> m_services = new Dictionary<Type, IService>();

		#endregion

		#region service registration

		public static void AddService<SerivceInterfaceType>(IService newService)
		{
			m_services.Add(typeof(SerivceInterfaceType), newService);

			BuildInterServiceDependencies<SerivceInterfaceType>(newService);
		}

		private static void BuildInterServiceDependencies<SerivceInterfaceType>(IService newService)
		{
			foreach (IService service in m_services.Values)
			{
				if (!service.Equals(newService)) service.OnServiceAvailable(typeof(SerivceInterfaceType));
			}

			foreach (Type serviceType in m_services.Keys)
			{
				if (!serviceType.Equals(typeof(SerivceInterfaceType))) newService.OnServiceAvailable(serviceType);
			}
		}

		#endregion

		#region service access

		public static SerivceInterfaceType GetService<SerivceInterfaceType>() 
		{
			if (m_services.ContainsKey(typeof(SerivceInterfaceType)))
			{
				return (SerivceInterfaceType)m_services[typeof(SerivceInterfaceType)];
			}
			else
			{
				return default(SerivceInterfaceType);
			}
		}

		#endregion
	}
}
