using System;
using System.Collections.Generic;
using System.Windows.Forms;

using SOAApplication.Services;

namespace SOAApplication
{
	static class Program
	{
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			RegisterServices();

			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);
			Application.Run(new MainForm());
		}

		private static void RegisterServices()
		{
			ServiceBroker.AddService<ISelectionService>(new SelectionService());
			ServiceBroker.AddService<IModelService>(new ModelSerivce());
			ServiceBroker.AddService<IHistoryService>(new HistoryService());
			//ServiceBroker.AddService<IMOUService>(new MOUService());
		}

	}
}