using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using SOAApplication.Services;

namespace SOAApplication
{
	public partial class MainForm : Form
	{
		public MainForm()
		{
			InitializeComponent();

			ConnectToServices();
		}

		#region bind to services

		IModelService m_modelService = null;
		IMOUService m_mouService = null;
		IHistoryService m_historyService = null;

		private void ConnectToServices()
		{
			m_modelService = ServiceBroker.GetService<IModelService>();
			if (m_modelService != null)
			{
				m_modelService.OnModelChanged += new ModelChangedEvent(modelService_OnModelChanged);
			}

			m_mouService = ServiceBroker.GetService<IMOUService>();
			m_historyService = ServiceBroker.GetService<IHistoryService>();
		}

		#endregion

		#region service event handler

		void modelService_OnModelChanged()
		{
			string filename = m_modelService.CurrentFilename;
			if (filename == null)
			{
				this.Text = "SOA Sample Application";
			}
			else
			{
				this.Text = "SOA Sample Application - " + filename;
			}
		}

		#endregion

		#region menu handler

		private void mnuOpen_Click(object sender, EventArgs e)
		{
			if (openFileDialog.ShowDialog(this) == DialogResult.OK)
			{
				ServiceBroker.GetService<IModelService>().LoadModel(openFileDialog.FileName);
			}
		}

		private void mnuExit_Click(object sender, EventArgs e)
		{
			this.Close();
		}

		private void mnuClose_Click(object sender, EventArgs e)
		{
			ServiceBroker.GetService<IModelService>().CloseModel();
		}

		private void mnuResetHistory_Click(object sender, EventArgs e)
		{
			if (m_historyService != null) m_historyService.Reset();
			if (m_mouService != null) m_mouService.Reset();
		}

		#endregion
	}
}