using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;


using SOAApplication.Services;

namespace SOAApplication.Controls
{
	public partial class TextView : UserControl
	{
		public TextView()
		{
			InitializeComponent();

			ISelectionService selectionService = ServiceBroker.GetService<ISelectionService>();
			if (selectionService != null)
			{
				selectionService.OnSelectionChanged += new SelectionChangedEvent(selectionService_OnSelectionChanged);
			}
		}

		void selectionService_OnSelectionChanged(System.Xml.XmlElement newSelection)
		{
			m_textbox.Text = (newSelection == null) ? "" : newSelection.InnerText;
		}
	}
}
