using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Xml;

using SOAApplication.Services;

namespace SOAApplication.Controls
{
	public partial class StructureView : UserControl
	{
		public StructureView()
		{
			InitializeComponent();

			ConnectToServices();

		}

		private void ConnectToServices()
		{
			if (GetModelService() != null)
			{
				GetModelService().OnModelChanged += new ModelChangedEvent(modelSerivce_OnModelChanged);
			}

			IMOUService mouService = ServiceBroker.GetService<IMOUService>();
			if (mouService != null)
			{
				mouService.OnTopChanged += new TopChangedEvent(mouService_OnTopChanged);
			}
		}

		private IModelService GetModelService()
		{
			return ServiceBroker.GetService<IModelService>(); 
		}

        void mouService_OnTopChanged(IVisitedElement newTop, IVisitedElement oldTop)
        {
            TreeNode oldNode = null;
            if (oldTop != null)
            {
                oldNode = FindElementsNode(oldTop.Element);
                if (oldNode != null)
                {
                    if (oldNode.Text.StartsWith("*")) oldNode.Text = oldNode.Text.Substring(1);
                }
            }

            if (newTop != null)
            {
                TreeNode newNode = FindElementsNode(newTop.Element);
                if (newNode != null) newNode.Text = "*" + newNode.Text;
            }
        }

		private TreeNode FindElementsNode(XmlElement elementToFind)
		{
			return InternalFindElementsNode(m_treeView.Nodes, elementToFind);
		}

		private TreeNode InternalFindElementsNode(TreeNodeCollection subtree, XmlElement elementToFind)
		{
			foreach (TreeNode node in subtree)
			{
				if (node.Tag == elementToFind) return node;

				TreeNode subSearchResult = InternalFindElementsNode(node.Nodes, elementToFind);
				if (subSearchResult != null) return subSearchResult;
			}
			return null;
		}

		void modelSerivce_OnModelChanged()
		{
			m_treeView.Nodes.Clear();

			if (GetModelService().CurrentModel != null)
			{
				FillTree(GetModelService().CurrentModel.DocumentElement, null);
			}
		}

		private void FillTree(XmlElement xmlElement, TreeNode parentNode)
		{
			TreeNode newNode = new TreeNode(xmlElement.Name);
			newNode.Tag = xmlElement;

			if (parentNode == null)
			{
				m_treeView.Nodes.Add(newNode);
			}
			else
			{
				parentNode.Nodes.Add(newNode);
			}

			foreach (XmlNode subNode in xmlElement.ChildNodes)
			{
				if (subNode.NodeType == XmlNodeType.Element)
				{
					FillTree(subNode as XmlElement, newNode);
				}
			}
		}

		private void treeView1_AfterSelect(object sender, TreeViewEventArgs e)
		{
			ISelectionService selectionService = ServiceBroker.GetService<ISelectionService>();

			if ((selectionService != null) && (m_treeView.SelectedNode != null))
			{
				selectionService.Select(m_treeView.SelectedNode.Tag as XmlElement);
			}
		}

		private void StructureView_Leave(object sender, EventArgs e)
		{
			m_treeView.SelectedNode = null;
		}
	}
}
