using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

using SOAApplication.Services;

namespace SOAApplication.Controls
{
	public partial class MOUList : UserControl
	{
		public MOUList()
		{
			InitializeComponent();

			if (ServiceBroker.GetService<IMOUService>() != null)
			{
				ServiceBroker.GetService<IMOUService>().OnMOUListChanged += new MOUListChangedEvent(MOUList_OnMOUListChanged);
			}
		}

		void MOUList_OnMOUListChanged(IMOUService source)
		{
			m_listBox.Items.Clear();

			IVisitedElement[] list = source.MOUList;
			foreach (IVisitedElement element in list)
			{
				m_listBox.Items.Add(element);
			}
		}
	}
}
