using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Xml;

using SOAApplication.Services;

namespace SOAApplication.Controls
{
	public partial class HistoryView : UserControl
	{
		private class HistoryItem
		{
			public HistoryItem(XmlElement element)
			{
				m_element = element;
			}

			XmlElement m_element;

			public override string ToString()
			{
				return m_element.Name;
			}

			public void Select()
			{
				ServiceBroker.GetService<ISelectionService>().Select(m_element);
			}
		}

		public HistoryView()
		{
			InitializeComponent();

			IHistoryService historyService = ServiceBroker.GetService<IHistoryService>();
			if (historyService != null)
			{
				historyService.OnHistoryCleared += new HistoryCleared(historyService_OnHistoryCleared);
				historyService.OnHistoryEntryAdded += new HistoryEntryAdded(historyService_OnHistoryEntryAdded);
			}
		}

		void historyService_OnHistoryEntryAdded(XmlElement newEntry)
		{
			m_listBox.Items.Insert(0, new HistoryItem(newEntry));
		}

		void historyService_OnHistoryCleared()
		{
			m_listBox.Items.Clear();
		}

		private void listBox_MouseDoubleClick(object sender, MouseEventArgs e)
		{
			int index = m_listBox.IndexFromPoint(e.Location);
			if (index >= 0)
			{
				((HistoryItem)m_listBox.Items[index]).Select();
			}
		}
	}
}
