using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

using System.Xml;
using SOAApplication.Services;

namespace SOAApplication.Controls
{
	public partial class BreadCrumbs : UserControl
	{
		private class ElementLabel : LinkLabel
		{
			public ElementLabel()
			{
				this.AutoSize = true;
			}

			private XmlElement m_element;

			public XmlElement Element
			{
				get 
				{ 
					return m_element; 
				}
				set 
				{ 
					m_element = value;
					if (m_element != null)
					{
						Text = m_element.Name;
					}
				}
			}

			protected override void OnClick(EventArgs e)
			{
				ServiceBroker.GetService<ISelectionService>().Select(m_element);
			}
		}

		public BreadCrumbs()
		{
			InitializeComponent();

			ISelectionService selectionService = ServiceBroker.GetService<ISelectionService>();
			if (selectionService != null)
			{
				selectionService.OnSelectionChanged += new SelectionChangedEvent(selectionService_OnSelectionChanged);
			}
		}

		void selectionService_OnSelectionChanged(XmlElement newSelection)
		{
			if (newSelection == null)
			{
				m_breadCrumbPanel.Controls.Clear();
			}
			else
			{
				BuildBreadCrumb(newSelection);
			}
		}

		private void BuildBreadCrumb(XmlElement xmlElement)
		{
			m_breadCrumbPanel.Controls.Clear();

			List<XmlElement> path = new List<XmlElement>();
			XmlElement current = xmlElement.ParentNode as XmlElement;
			while (current != null)
			{
				path.Insert(0, current);
				current = current.ParentNode as XmlElement;
			}

			foreach (XmlElement elementOnPath in path)
			{
				ElementLabel newLabel = new ElementLabel();
				newLabel.Element = elementOnPath;
				m_breadCrumbPanel.Controls.Add(newLabel);

				Label newSeparator = new Label();
				newSeparator.Text = " >> ";
				newSeparator.AutoSize = true;
				m_breadCrumbPanel.Controls.Add(newSeparator);
			}

			Label theElementItSelf = new Label();
			theElementItSelf.AutoSize = true;
			theElementItSelf.Text = xmlElement.Name;

			m_breadCrumbPanel.Controls.Add(theElementItSelf);
		}
	}
}
